//*****************************************************************************
// Arquivo my_ints.c - tratamento das interrupções no PIC by Arne
// Desenvolvido por Márcio José Soares
//*****************************************************************************

//*****************************************************************************
// O Copyright deste programa está reservado para TESC Sistemas de Controle LTDA
// e seu conteúdo está protegido pela Lei de Direitos Autorais LEI Nº 9.610, de
// 19 de Fevereiro de 1998. É estritamente proibida a reprodução total ou
// parcial dos conteúdos aqui apresentados sem prévia autorização, por escrito,
// do autor.
//****************************************************************************** 

//******************************************************************************
// Arquivos incluídos no módulo
//******************************************************************************
#include <xc.h>
#include <stdio.h>
#include <stdlib.h>

#include "my_defines.h"

//******************************************************************************
// Variáveis externas ao módulo
//******************************************************************************

//*****************************************************************************
// Funções externas do módulo
//*****************************************************************************
extern void trata_int_ext(void);

//*****************************************************************************
// Funções do módulo
//*****************************************************************************

//*****************************************************************************
// Função para tratar o vetor de interrupções no PIC
//
//  Este é o tratamento de interrupçõe no PIC. Como este microcontrolador possui
//  apenas um único vetor de interrupção (0x0004), toda e qualquer interrupção será
//  tratada aqui. Se uma única interrupção for utilizada, o tratamento pode ser direto,
//  sem a necessidade de se testar qual int ocorreu. Porém se mais de uma estiver
//  em uso, a função deverá testar os flags das ints para saber qual ocorreu, extamente
//  como é feito em assembly.
//  O uso da diretriz "interrupt 0" é importante, pois é assim que o SDCC reconhece que
//  esta função é na verdade um serviço para tratamento das interrupções. Para PICs usar
//  apenas nível 0.
//
// Entradas - nenhuma
// Saídas   - nenhuma
//*****************************************************************************
void __interrupt() pic_isr(void){
    
    INTCONbits.GIE = 0;                  // desabilita ints globais
    
    if((INTCONbits.INTF == 1) && (INTCONbits.INTE == 1)){   // int externa
        trata_int_ext();                                        // trata
        INTCONbits.INTF = 0;                                  // limpa flag
    }
    
    INTCONbits.GIE = 1;                  // habilita ints globais
}

